(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.module = f()}})(function(){var define,module,exports;return (function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){
const events = {

    update: function(ui) {
        updateModelLabels(ui.blocks, _('Block {0}'));
        calcBlocks(ui, this);
        filterBlocks(ui, this);

        calcModelTerms(ui, this);
        updateLevelControls(ui, this);
    },

    onChange_covs: function(ui) {
        calcBlocks(ui, this);
    },

    onChange_dep:  function(ui) {
        calcModelTerms(ui, this);
    },

    onChange_factors: function(ui) {
        calcBlocks(ui, this);
        calcModelTerms(ui, this);
    },

    onChange_blocks: function(ui) {
        checkForNullBlocks(ui, this);
    },

    onChange_block: function(ui) {
        filterBlocks(ui, this);
    },

    onChange_refLevels: function(ui) {
        updateLevelControls(ui, this);
    },

    onEvent_test_listItemsChanged: function(ui) {
        updateModelLabels(ui.blocks, _('Block {0}'));
        let blocks = this.clone(ui.blocks.value(), []);
        this.workspace["blocks"] = blocks;
    },

    onUpdate_modelSupplier: function(ui) {
        let variableList = this.clone(ui.covs.value(), []);
        variableList = variableList.concat(this.clone(ui.factors.value(), []));
        ui.modelSupplier.setValue(this.valuesToItems(variableList, FormatDef.variable));
    }
};

var calcModelTerms = function(ui, context) {
    var variableList = context.clone(ui.factors.value(), []);

    updateContrasts(ui, variableList, context);
};

var updateLevelControls = function(ui, context) {
    let dlist = ui.refLevels.value();
    let list = ui.refLevels.applyToItems(0, (item, index, column) => {
        if (column === 1)
            item.setPropertyValue('variable', dlist[index].var );
    });
};

var updateContrasts = function(ui, variableList, context) {
    var currentList = context.clone(ui.refLevels.value(), []);

    var list3 = [];
    for (let i = 0; i < variableList.length; i++) {
        let found = null;
        for (let j = 0; j < currentList.length; j++) {
            if (currentList[j].var === variableList[i]) {
                found = currentList[j];
                break;
            }
        }
        if (found === null)
            list3.push({ var: variableList[i], ref: null });
        else
            list3.push(found);
    }

    ui.refLevels.setValue(list3);
};


let updateModelLabels = function(list, blockName) {
    list.applyToItems(0, (item, index) => {
        item.controls[0].setPropertyValue("label", blockName.replace('{0}', (index + 1) ));
    });
};


let calcBlocks = function(ui, context) {
    let variableList = context.clone(ui.covs.value(), []);
    variableList = variableList.concat(context.clone(ui.factors.value(), []));

    ui.modelSupplier.setValue(context.valuesToItems(variableList, FormatDef.variable));


    let varsDiff = context.findChanges("variableList", variableList, true, FormatDef.variable);
    let termsList = context.clone(ui.blocks.value(), []);

    var termsChanged = false;
    for (var i = 0; i < varsDiff.removed.length; i++) {
        for (var j = 0; j < termsList.length; j++) {
            if (termsList[j] === null)
                termsList[j] = [];

            for (var k = 0; k < termsList[j].length; k++) {
                if (FormatDef.term.contains(termsList[j][k], varsDiff.removed[i])) {
                    termsList[j].splice(k, 1);
                    termsChanged = true;
                    k -= 1;
                }
            }
        }
    }

    let selectedRows = ui.blocks.getSelectedRowIndices();
    if (selectedRows.length > 0) {
        if (termsList[selectedRows[selectedRows.length - 1]] === null)
            termsList[selectedRows[selectedRows.length - 1]]  = [];
        for (let i = 0; i < varsDiff.added.length; i++)
            termsList[selectedRows[selectedRows.length - 1]].push([varsDiff.added[i]]);
        //termsList[selectedRows[selectedRows.length - 1]] = context.getCombinations(varsDiff.added, termsList[selectedRows[selectedRows.length - 1]]);
        termsChanged = termsChanged || varsDiff.added.length > 0;
    }


    if (termsChanged)
        ui.blocks.setValue(termsList);
};

let inOtherBlock = function(blocks, value, blockIndex) {
    for (let b = 0; b < blocks.length; b++) {
        if (b === blockIndex)
            continue;

        let block = blocks[b];
        for (let i = 0; i < block.length; i++) {
            if (FormatDef.term.isEqual(block[i], value))
                return true;
        }
    }
    return false;
};

let checkForNullBlocks = function(ui, context) {
    let changed = false;
    let blocks = context.clone(ui.blocks.value(), []);
    for (let blockIndex = 0; blockIndex < blocks.length; blockIndex++)  {
        if (blocks[blockIndex] === null) {
            changed = true;
            blocks[blockIndex] = [];
        }
    }

    if (changed)
        ui.blocks.setValue(blocks);
};

let filterBlocks = function(ui, context) {
    let changed = false;
    let blocks = context.clone(ui.blocks.value(), []);

    let prevBlocks = context.workspace["blocks"];

    for (let blockIndex = 0; blockIndex < blocks.length; blockIndex++)  {
        if (blocks[blockIndex] === null) {
            changed = true;
            blocks[blockIndex] = [];
        }

        let termsList = blocks[blockIndex];

        if (prevBlocks !== undefined && prevBlocks.length === blocks.length) {
            //Remove common terms
            let termsDiff = context.findDifferences(prevBlocks[blockIndex], termsList, FormatDef.term);

            if (termsDiff.removed.length > 0 && termsList !== null) {
                let itemsRemoved = false;
                for (let i = 0; i < termsDiff.removed.length; i++) {
                    let item = termsDiff.removed[i];
                    for (let j = 0; j < termsList.length; j++) {
                        if (FormatDef.term.contains(termsList[j], item)) {
                            termsList.splice(j, 1);
                            j -= 1;
                            itemsRemoved = true;
                        }
                    }
                }

                if (itemsRemoved)
                    changed = true;
            }
            /////////////////////
        }

        //Sort terms
        if (context.sortArraysByLength(termsList))
            changed = true;
        ////////////
    }

    //remove terms that have been added that clash with existing terms
    for (let blockIndex = 0; blockIndex < blocks.length; blockIndex++)  {
        let termsList = blocks[blockIndex];

        if (prevBlocks !== undefined && prevBlocks.length === blocks.length) {
            let termsDiff = context.findDifferences(prevBlocks[blockIndex], termsList, FormatDef.term);

            if (termsDiff.added.length > 0 && termsList !== null) {
                let itemsRemoved = false;
                for (let i = 0; i < termsDiff.added.length; i++) {
                    let item = termsDiff.added[i];
                    if (inOtherBlock(blocks, item, blockIndex)) {
                        for (let j = 0; j < termsList.length; j++) {
                            if (FormatDef.term.isEqual(termsList[j], item)) {
                                termsList.splice(j, 1);
                                j -= 1;
                                itemsRemoved = true;
                            }
                        }
                    }
                }

                if (itemsRemoved)
                    changed = true;
            }
        }
    }
    /////////////////////////////////////////////////////////////////



    context.workspace["blocks"] = blocks;

    if (changed)
        ui.blocks.setValue(blocks);
};


module.exports = events;

},{}],2:[function(require,module,exports){

// This file is an automatically generated and should not be edited

'use strict';

const options = [{"name":"data","type":"Data","description":{"R":"the data as a data frame"}},{"name":"dep","type":"Variable","title":"Dependent Variable","suggested":["ordinal"],"permitted":["factor"],"description":{"R":"a string naming the dependent variable from `data`, variable must be a factor\n"}},{"name":"covs","title":"Covariates","type":"Variables","suggested":["continuous"],"permitted":["numeric"],"default":null,"description":{"R":"a vector of strings naming the covariates from `data`"}},{"name":"factors","title":"Factors","type":"Variables","suggested":["nominal"],"permitted":["factor"],"default":null,"description":{"R":"a vector of strings naming the fixed factors from `data`"}},{"name":"blocks","title":"Blocks","type":"Array","default":[[]],"template":{"type":"Terms"},"description":{"R":"a list containing vectors of strings that name the predictors that are added to the model. The elements are added to the model according to their order in the list\n"}},{"name":"refLevels","title":"Reference Levels","type":"Array","default":null,"template":{"type":"Group","elements":[{"name":"var","type":"Variable"},{"name":"ref","type":"Level"}]},"description":{"R":"a list of lists specifying reference levels of the dependent variable and all the factors\n"}},{"name":"modelTest","title":"Overall model test","type":"Bool","default":false,"description":{"R":"`TRUE` or `FALSE` (default), provide the model comparison between the models and the NULL model\n"}},{"name":"dev","title":"Deviance","type":"Bool","default":true,"description":{"R":"`TRUE` (default) or `FALSE`, provide the deviance (or -2LogLikelihood) for the models\n"}},{"name":"aic","title":"AIC","type":"Bool","default":true,"description":{"R":"`TRUE` (default) or `FALSE`, provide Akaike's Information Criterion (AIC) for the models\n"}},{"name":"bic","title":"BIC","type":"Bool","default":false,"description":{"R":"`TRUE` or `FALSE` (default), provide Bayesian Information Criterion (BIC) for the models\n"}},{"name":"pseudoR2","title":"Pseudo R²","type":"NMXList","options":[{"name":"r2mf","title":"McFadden's R²"},{"name":"r2cs","title":"Cox & Snell's R²"},{"name":"r2n","title":"Nagelkerke's R²"}],"default":["r2mf"],"description":{"R":"one or more of `'r2mf'`, `'r2cs'`, or `'r2n'`; use McFadden's, Cox & Snell, and Nagelkerke pseudo-R², respectively\n"}},{"name":"omni","title":"Likelihood ratio tests","type":"Bool","default":false,"description":{"R":"`TRUE` or `FALSE` (default), provide the omnibus likelihood ratio tests for the predictors\n"}},{"name":"thres","title":"Model thresholds","type":"Bool","default":false,"description":{"R":"`TRUE` or `FALSE` (default), provide the thresholds that are used as cut-off scores for the levels of the dependent variable\n"}},{"name":"ci","title":"Confidence interval","type":"Bool","default":false,"description":{"R":"`TRUE` or `FALSE` (default), provide a confidence interval for the model coefficient estimates\n"}},{"name":"ciWidth","title":"Confidence level","type":"Number","min":50,"max":99.9,"default":95,"description":{"R":"a number between 50 and 99.9 (default: 95) specifying the confidence interval width\n"}},{"name":"OR","title":"Odds ratio","type":"Bool","default":false,"description":{"R":"`TRUE` or `FALSE` (default), provide the exponential of the log-odds ratio estimate, or the odds ratio estimate\n"}},{"name":"ciOR","title":"Confidence interval","type":"Bool","default":false,"description":{"R":"`TRUE` or `FALSE` (default), provide a confidence interval for the model coefficient odds ratio estimates\n"}},{"name":"ciWidthOR","title":"Confidence level","type":"Number","min":50,"max":99.9,"default":95,"description":{"R":"a number between 50 and 99.9 (default: 95) specifying the confidence interval width\n"}}];

const view = function() {
    
    

    View.extend({
        jus: "2.0",

        events: [

	],

	update: require('./logregord.events').update

    }).call(this);
}

view.layout = ui.extend({

    label: "Ordinal Logistic Regression",
    jus: "2.0",
    type: "root",
    stage: 0, //0 - release, 1 - development, 2 - proposed
    controls: [
		{
			type: DefaultControls.VariableSupplier,
			typeName: 'VariableSupplier',
			stretchFactor: 1,
			controls: [
				{
					type: DefaultControls.TargetLayoutBox,
					typeName: 'TargetLayoutBox',
					controls: [
						{
							type: DefaultControls.VariablesListBox,
							typeName: 'VariablesListBox',
							name: "dep",
							isTarget: true,
							maxItemCount: 1,
							events: [
								{ execute: require('./logregord.events').onChange_dep }
							]
						}
					]
				},
				{
					type: DefaultControls.TargetLayoutBox,
					typeName: 'TargetLayoutBox',
					label: "Covariates",
					controls: [
						{
							type: DefaultControls.VariablesListBox,
							typeName: 'VariablesListBox',
							name: "covs",
							isTarget: true,
							events: [
								{ execute: require('./logregord.events').onChange_covs }
							]
						}
					]
				},
				{
					type: DefaultControls.TargetLayoutBox,
					typeName: 'TargetLayoutBox',
					label: "Factors",
					controls: [
						{
							type: DefaultControls.VariablesListBox,
							typeName: 'VariablesListBox',
							name: "factors",
							isTarget: true,
							events: [
								{ execute: require('./logregord.events').onChange_factors }
							]
						}
					]
				}
			]
		},
		{
			type: DefaultControls.CollapseBox,
			typeName: 'CollapseBox',
			label: "Model Builder",
			collapsed: true,
			stretchFactor: 1,
			controls: [
				{
					type: DefaultControls.Supplier,
					typeName: 'Supplier',
					name: "modelSupplier",
					label: "Predictors",
					persistentItems: true,
					stretchFactor: 1,
					format: FormatDef.term,
					events: [
						{ onEvent: 'update', execute: require('./logregord.events').onUpdate_modelSupplier }
					],
					controls: [
						{
							type: DefaultControls.TargetLayoutBox,
							typeName: 'TargetLayoutBox',
							transferAction: "interactions",
							controls: [
								{
									type: DefaultControls.ListBox,
									typeName: 'ListBox',
									name: "blocks",
									height: "normal",
									addButton: "Add New Block",
									events: [
										{ execute: require('./logregord.events').onChange_blocks },
										{ onEvent: 'listItemAdded', execute: require('./logregord.events').onEvent_test_listItemsChanged },
										{ onEvent: 'listItemRemoved', execute: require('./logregord.events').onEvent_test_listItemsChanged }
									],
									selectable: true,
									templateName: "linreg-block-template",
									template:
									{
										type: DefaultControls.LayoutBox,
										typeName: 'LayoutBox',
										margin: "normal",
										targetArea: true,
										controls: [
											{
												type: DefaultControls.Label,
												typeName: 'Label',
												label: "Block 1",
												name: "blockName",
												stretchFactor: 1,
												margin: "normal"
											},
											{
												type: DefaultControls.ListBox,
												typeName: 'ListBox',
												name: "blockList",
												isTarget: true,
												valueFilter: "unique",
												height: "auto",
												ghostText: "drag variables here",
												events: [
													{ execute: require('./logregord.events').onChange_block }
												],
												template:
												{
													type: DefaultControls.TermLabel,
													typeName: 'TermLabel'
												}												
											}
										]
									}									
								}
							]
						}
					]
				}
			]
		},
		{
			type: DefaultControls.CollapseBox,
			typeName: 'CollapseBox',
			label: "Reference Levels",
			collapsed: true,
			stretchFactor: 1,
			controls: [
				{
					type: DefaultControls.ListBox,
					typeName: 'ListBox',
					name: "refLevels",
					showColumnHeaders: true,
					fullRowSelect: true,
					stretchFactor: 1,
					height: "large",
					events: [
						{ execute: require('./logregord.events').onChange_refLevels }
					],
					columns: [
						{
							name: "var",
							label: "Variable",
							selectable: false,
							stretchFactor: 1,
							maxWidth: 300,
							template:
							{
								type: DefaultControls.VariableLabel,
								typeName: 'VariableLabel'
							}							
						},
						{
							name: "ref",
							label: "Reference Level",
							selectable: false,
							stretchFactor: 0.5,
							template:
							{
								type: DefaultControls.LevelSelector,
								typeName: 'LevelSelector',
								label: ""
							}							
						}
					]
				}
			]
		},
		{
			type: DefaultControls.CollapseBox,
			typeName: 'CollapseBox',
			label: "Model Fit",
			collapsed: true,
			stretchFactor: 1,
			controls: [
				{
					type: DefaultControls.LayoutBox,
					typeName: 'LayoutBox',
					margin: "large",
					stretchFactor: 1,
					controls: [
						{
							type: DefaultControls.LayoutBox,
							typeName: 'LayoutBox',
							cell: {"column":0,"row":0},
							stretchFactor: 1,
							controls: [
								{
									type: DefaultControls.Label,
									typeName: 'Label',
									label: "Fit Measures",
									controls: [
										{
											type: DefaultControls.CheckBox,
											typeName: 'CheckBox',
											name: "dev"
										},
										{
											type: DefaultControls.CheckBox,
											typeName: 'CheckBox',
											name: "aic"
										},
										{
											type: DefaultControls.CheckBox,
											typeName: 'CheckBox',
											name: "bic"
										},
										{
											type: DefaultControls.CheckBox,
											typeName: 'CheckBox',
											name: "modelTest"
										}
									]
								}
							]
						},
						{
							type: DefaultControls.LayoutBox,
							typeName: 'LayoutBox',
							cell: {"column":1,"row":0},
							stretchFactor: 1,
							controls: [
								{
									type: DefaultControls.Label,
									typeName: 'Label',
									label: "Pseudo R²",
									controls: [
										{
											name: "pseudoR2_r2mf",
											type: DefaultControls.CheckBox,
											typeName: 'CheckBox',
											optionName: "pseudoR2",
											optionPart: "r2mf"
										},
										{
											name: "pseudoR2_r2cs",
											type: DefaultControls.CheckBox,
											typeName: 'CheckBox',
											optionName: "pseudoR2",
											optionPart: "r2cs"
										},
										{
											name: "pseudoR2_r2n",
											type: DefaultControls.CheckBox,
											typeName: 'CheckBox',
											optionName: "pseudoR2",
											optionPart: "r2n"
										}
									],
									name: "pseudoR2"
								}
							]
						}
					]
				}
			]
		},
		{
			type: DefaultControls.CollapseBox,
			typeName: 'CollapseBox',
			label: "Model Coefficients",
			collapsed: true,
			stretchFactor: 1,
			controls: [
				{
					type: DefaultControls.LayoutBox,
					typeName: 'LayoutBox',
					margin: "large",
					stretchFactor: 1,
					controls: [
						{
							type: DefaultControls.LayoutBox,
							typeName: 'LayoutBox',
							cell: {"column":0,"row":0},
							stretchFactor: 1,
							controls: [
								{
									type: DefaultControls.Label,
									typeName: 'Label',
									label: "Omnibus Tests",
									controls: [
										{
											type: DefaultControls.CheckBox,
											typeName: 'CheckBox',
											name: "omni"
										}
									]
								},
								{
									type: DefaultControls.Label,
									typeName: 'Label',
									label: "Thresholds",
									controls: [
										{
											type: DefaultControls.CheckBox,
											typeName: 'CheckBox',
											name: "thres"
										}
									]
								}
							]
						},
						{
							type: DefaultControls.LayoutBox,
							typeName: 'LayoutBox',
							cell: {"column":1,"row":0},
							stretchFactor: 1,
							controls: [
								{
									type: DefaultControls.Label,
									typeName: 'Label',
									label: "Estimate (Log Odds Ratio)",
									controls: [
										{
											type: DefaultControls.CheckBox,
											typeName: 'CheckBox',
											name: "ci",
											controls: [
												{
													type: DefaultControls.TextBox,
													typeName: 'TextBox',
													name: "ciWidth",
													label: "Interval",
													suffix: "%",
													format: FormatDef.number,
													enable: "(ci)"
												}
											]
										}
									]
								},
								{
									type: DefaultControls.Label,
									typeName: 'Label',
									label: "Odds Ratio",
									controls: [
										{
											type: DefaultControls.CheckBox,
											typeName: 'CheckBox',
											name: "OR"
										},
										{
											type: DefaultControls.CheckBox,
											typeName: 'CheckBox',
											name: "ciOR",
											enable: "(OR)",
											controls: [
												{
													type: DefaultControls.TextBox,
													typeName: 'TextBox',
													name: "ciWidthOR",
													label: "Interval",
													suffix: "%",
													format: FormatDef.number,
													enable: "(ciOR)"
												}
											]
										}
									]
								}
							]
						}
					]
				}
			]
		}
	]
});

module.exports = { view : view, options: options };

},{"./logregord.events":1}]},{},[2])(2)
});
